<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\Api\AdvisorController;
use App\Http\Controllers\Api\FinderController;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\AdminController;


Route::get('/login', function () {
    return view('auth.login');
})->name('login');

Route::post('/login', function (\Illuminate\Http\Request $request) {
    $credentials = $request->only('email', 'password');

    if (Auth::attempt($credentials)) {
        $request->session()->regenerate();
        return redirect('/admin/dashboard');
    }

    return back()->withErrors(['email' => 'Invalid credentials']);
});

Route::post('/logout', function (\Illuminate\Http\Request $request) {
    Auth::logout();
    return redirect('/login');
})->name('logout');

Route::middleware('auth')->prefix('admin')->group(function () {
    Route::get('/dashboard', [AdminController::class, 'dashboard'])->name('admin.dashboard');
    Route::get('/logs', [AdminController::class, 'logs'])->name('admin.logs');
});

/*Route::middleware('api.key')->group(function () {
    Route::post('advisor', [AdvisorController::class, 'handle']);
    Route::get('finder', [FinderController::class, 'handle']);
});*/


Route::get('/', function () {
    return view('welcome');
});


Route::get('/setup', function () {
    try {
        \Artisan::call('migrate --force');
        \Artisan::call('db:seed --force');
        \Artisan::call('storage:link');
        return "Setup complete! Migrations and seeding done. Delete this route now.";
    } catch (\Exception $e) {
        return "Error: " . $e->getMessage();
    }
});

Route::get('/clear-cache', function () {
    Artisan::call('config:clear');
    Artisan::call('cache:clear');
    Artisan::call('route:clear');
    Artisan::call('view:clear');
    Artisan::call('optimize:clear');
    return "Cache cleared! You can now delete this route.";
});
/*Route::middleware('api.key')->group(function () {
    Route::post('/advisor', [AdvisorController::class, 'handle']);
    Route::get('/finder', [FinderController::class, 'handle']);
});*/

/*Route::middleware('auth')->prefix('admin')->group(function () {
    Route::get('/dashboard', [AdminController::class, 'dashboard']);
    Route::resource('users', UserController::class);
    Route::resource('api-keys', ApiKeyController::class);
    Route::get('/logs', [AdminController::class, 'logs']);
});*/
