## Database Schema

The Laravel gateway uses a MySQL (or MariaDB) database with three main tables:

### 1. `users` (Default Laravel Auth Table)

| Column              | Type              | Description                          |
|---------------------|-------------------|--------------------------------------|
| `id`                | bigint unsigned   | Primary key                          |
| `name`              | varchar(255)      | User's full name                     |
| `email`             | varchar(255)      | Unique email address                 |
| `email_verified_at` | timestamp         | Nullable – email verification time   |
| `password`          | varchar(255)      | Hashed password                      |
| `remember_token`    | varchar(100)      | Nullable                             |
| `created_at`        | timestamp         |                                      |
| `updated_at`        | timestamp         |                                      |

### 2. `user_api_keys`

Stores one or more API keys per user.

| Column                     | Type              | Description                                      | Default / Notes                  |
|----------------------------|-------------------|--------------------------------------------------|----------------------------------|
| `id`                       | bigint unsigned   | Primary key                                      |                                  |
| `user_id`                  | bigint unsigned   | Foreign key → users.id (cascade delete)          |                                  |
| `key`                      | varchar(255)      | Unique random API key (e.g., 40 characters)      | Unique index                     |
| `name`                     | varchar(255)      | Friendly name (e.g., "My Mobile App")            | Nullable                         |
| `rate_limit_per_minute`    | integer           | Max requests per minute for this key             | 60                               |
| `is_active`                | boolean           | Whether the key is enabled                       | true                             |
| `expires_at`               | timestamp         | Optional expiration date                         | Nullable                         |
| `created_at`               | timestamp         |                                                  |                                  |
| `updated_at`               | timestamp         |                                                  |                                  |

**Relationships**:  
- `user()` → belongsTo(User::class)  
- `apiCallLogs()` → hasMany(ApiCallLog::class)

### 3. `api_call_logs`

Complete audit trail of every API request made through the gateway.

| Column               | Type              | Description                                      | Notes                            |
|----------------------|-------------------|--------------------------------------------------|----------------------------------|
| `id`                 | bigint unsigned   | Primary key                                      |                                  |
| `user_api_key_id`    | bigint unsigned   | Foreign key → user_api_keys.id (cascade delete)  | Indexed                          |
| `endpoint`           | varchar(255)      | Called endpoint (e.g., "advisor", "finder")      |                                  |
| `method`             | varchar(10)       | HTTP method (GET, POST, etc.)                    |                                  |
| `ip_address`         | ipAddress         | Client IP address                                |                                  |
| `request_data`       | json              | Full request payload/query params                | Nullable                         |
| `response_code`      | integer           | HTTP status returned from AWS backend            |                                  |
| `response_time_ms`   | double            | Response time in milliseconds                    |                                  |
| `created_at`         | timestamp         | Request timestamp                                | Indexed                          |
| `updated_at`         | timestamp         |                                                  |                                  |

**Relationships**:  
- `userApiKey()` → belongsTo(UserApiKey::class)

### Indexes for Performance

- `user_api_keys.key` → UNIQUE
- `user_api_keys.user_id`
- `api_call_logs.user_api_key_id`
- `api_call_logs.created_at` (for time-based queries)
- `api_call_logs.endpoint`

### Running Migrations

```bash
php artisan migrate
```

This creates all tables automatically.

### Seeding Initial Data

```bash
php artisan db:seed --class=UserSeeder
```

Creates:
- Admin user (`admin@caradvisor.test` / `password`)
- Test user (`test@user.com` / `test123`)
- One active API key for each user

You can now safely deploy and use the gateway knowing exactly how data is structured and protected.