<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('api_call_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_api_key_id')->constrained()->onDelete('cascade');
            $table->string('endpoint');
            $table->string('method');
            $table->ipAddress('ip_address');
            $table->json('request_data')->nullable();
            $table->integer('response_code');
            $table->float('response_time_ms');
            $table->timestamps();
            $table->index('created_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('api_call_logs');
    }
};
