<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>API Call Logs - Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
</head>

<body class="bg-light">

    <nav class="navbar navbar-dark bg-dark mb-4">
        <div class="container-fluid">
            <span class="navbar-brand mb-0 h1">Car Advisor Gateway - Admin</span>
            <div>
                <a href="<?php echo e(route('admin.dashboard')); ?>" class="btn btn-outline-light me-2">Dashboard</a>
                <form action="<?php echo e(route('logout')); ?>" method="POST" class="d-inline">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="btn btn-outline-danger">Logout</button>
                </form>
            </div>
        </div>
    </nav>

    <div class="container">
        <h2 class="mb-4">API Call Logs</h2>

        <div class="card shadow-sm">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover align-middle">
                        <thead class="table-dark">
                            <tr>
                                <th>#</th>
                                <th>Time</th>
                                <th>User</th>
                                <th>API Key Name</th>
                                <th>Endpoint</th>
                                <th>Method</th>
                                <th>IP Address</th>
                                <th>Status</th>
                                <th>Response Time</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if(empty($logs) || $logs->isEmpty()): ?>
                            <tr>
                                <td colspan="9" class="text-center py-4 text-muted">
                                    No logs found.
                                </td>
                            </tr>
                            <?php else: ?>

                            <?php $__empty_1 = true; $__currentLoopData = $logs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($loop->iteration + ($logs->currentPage() - 1) * $logs->perPage()); ?></td>
                                <td>
                                    <small><?php echo e($log->created_at->format('M d, Y H:i:s')); ?></small><br>
                                    <small class="text-muted"><?php echo e($log->created_at->diffForHumans()); ?></small>
                                </td>
                                <td>
                                    <?php echo e($log->userApiKey->user->name ?? 'Deleted User'); ?><br>
                                    <small class="text-muted"><?php echo e($log->userApiKey->user->email ?? ''); ?></small>
                                </td>
                                <td>
                                    <code class="small"><?php echo e(Str::limit($log->userApiKey->name ?? 'Unnamed', 20)); ?></code>
                                </td>
                                <td><strong>/<?php echo e($log->endpoint); ?></strong></td>
                                <!-- display if its a get or post requests --->
                                <td>
                                    <span class="badge bg-<?php echo e($log->method === 'POST' ? 'primary' : 'info'); ?>">
                                        <?php echo e($log->method); ?>

                                    </span>
                                </td>
                                <td><code><?php echo e($log->ip_address); ?></code></td>
                                <td>
                                    <span class="badge bg-<?php echo e($log->response_code < 400 ? 'success' : ($log->response_code < 500 ? 'warning' : 'danger')); ?>">
                                        <?php echo e($log->response_code); ?>

                                    </span>
                                </td>
                                <td><?php echo e(number_format($log->response_time_ms, 2)); ?> ms</td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="9" class="text-center py-4 text-muted">
                                    2 - No logs found.
                                </td>
                            </tr>
                            <?php endif; ?>

                            <?php endif; ?>

                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="d-flex justify-content-center mt-4">
                    <?php if($logs->isEmpty()): ?>
                        <style>
                            .pagination {
                                display: none;
                            }
                        </style>
                    <?php else: ?>
                        <?php echo e($logs->links()); ?>

                    <?php endif; ?>

                </div>
            </div>
        </div>
    </div>

</body>

</html><?php /**PATH C:\Users\User\Documents\UtilitiesScripts\learnings\laravel-ai-advisor-api\car-advisor-gateway\car-advisor-gateway\resources\views\admin\logs.blade.php ENDPATH**/ ?>