<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ApiCallLog extends Model
{
    //

    protected $fillable = [
        'user_api_key_id', 'endpoint', 'method', 'ip_address',
        'request_data', 'response_code', 'response_time_ms'
    ];

    protected $casts = [
        'request_data' => 'array',
    ];

    public function userApiKey(): BelongsTo
    {
        return $this->belongsTo(UserApiKey::class);
    }

    /*protected function logCall($request, $endpoint, $method, $result)
    {
        $keyRecord = $request->authenticated_api_key;

        ApiCallLog::create([
            'user_api_key_id' => $keyRecord->id,
            'endpoint' => $endpoint,
            'method' => $method,
            'ip_address' => $request->ip(),
            'request_data' => $request->all(),
            'response_code' => $result['status'],
            'response_time_ms' => $result['duration_ms'],
        ]);
    }*/
}
